/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import reliquary.init.ModItems;
import reliquary.items.SojournerStaffItem;
import reliquary.items.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;

public class LanternOfParanoiaItem
extends ToggleableItem {
    private static final int SUCCESS_COOLDOWN = 4;
    private static final int NOTHING_FOUND_COOLDOWN = 10;
    private static final Map<String, Block> TORCH_BLOCKS = new HashMap<String, Block>();

    public LanternOfParanoiaItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public int getRange() {
        return (Integer)Settings.COMMON.items.lanternOfParanoia.placementScanRadius.get();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || !this.isEnabled(stack) || this.isInCooldown(stack, world)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getPositionsInRange(player).anyMatch(pos -> this.tryToPlaceAtPos(stack, world, player, (BlockPos)pos))) {
                this.setCooldown(stack, world, 4);
            } else {
                this.setCooldown(stack, world, 10);
            }
        }
    }

    private Stream<BlockPos> getPositionsInRange(Player player) {
        return BlockPos.m_121990_((BlockPos)player.m_142538_().m_142082_(-this.getRange(), -this.getRange() / 2, -this.getRange()), (BlockPos)player.m_142538_().m_142082_(this.getRange(), this.getRange() / 2, this.getRange()));
    }

    private boolean tryToPlaceAtPos(ItemStack stack, Level world, Player player, BlockPos pos) {
        BlockPlaceContext context;
        Block block;
        int lightLevel = player.f_19853_.m_45517_(LightLayer.BLOCK, pos);
        if (lightLevel > (Integer)Settings.COMMON.items.lanternOfParanoia.minLightLevel.get()) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (this.isBadPlacementToTry(world, pos, state, block = state.m_60734_(), context = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.m_82539_((Vec3i)pos), Direction.UP, pos, false)))) {
            return false;
        }
        return this.tryToPlaceTorchAround(stack, pos, player, world);
    }

    private boolean isBadPlacementToTry(Level world, BlockPos pos, BlockState state, Block block, BlockPlaceContext context) {
        return block instanceof LiquidBlock || world.m_8055_(pos.m_7495_()).m_60734_().m_49967_() || !state.m_60819_().m_76178_() || !state.m_60795_() && !state.m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)pos, (Direction)Direction.DOWN));
    }

    private boolean isBlockBlockingView(Level world, Player player, BlockPos pos) {
        double playerEyeHeight = player.m_20186_() + (double)player.m_20192_();
        for (float xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    Vec3 rayTraceVector;
                    Vec3 playerVec = new Vec3(player.m_20185_() + (double)xOff, playerEyeHeight + (double)yOff, player.m_20189_() + (double)zOff);
                    BlockHitResult rayTraceResult = world.m_45547_(new ClipContext(playerVec, rayTraceVector = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5 + (double)xOff, 0.5 + (double)yOff, 0.5 + (double)zOff), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                    if (rayTraceResult.m_6662_() != HitResult.Type.MISS) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean tryToPlaceTorchAround(ItemStack stack, BlockPos pos, Player player, Level world) {
        if (this.isBlockBlockingView(world, player, pos)) {
            return false;
        }
        for (String torchRegistryName : (List)Settings.COMMON.items.lanternOfParanoia.torches.get()) {
            if (!this.getTorchBlock(torchRegistryName).map(torch -> this.tryToPlaceTorchBlock(stack, pos, player, world, (Block)torch)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tryToPlaceTorchBlock(ItemStack stack, BlockPos pos, Player player, Level world, Block torch) {
        if (torch.m_49966_().m_60710_((LevelReader)world, pos)) {
            ArrayList trySides = Lists.newArrayList((Object[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
            ItemStack torchStack = new ItemStack((ItemLike)torch);
            for (Direction side : trySides) {
                BlockState torchBlockState = this.getTorchSideAttempt(player, torch, pos, side);
                if (torchBlockState == null || !torchBlockState.m_60710_((LevelReader)world, pos) || !world.m_45752_(torchBlockState, pos, CollisionContext.m_82749_()) || !InventoryHelper.consumeItem(torchStack, player, 0, 1) && !this.findAndDrainSojournersStaff(player, torch) || !this.placeBlockAt(stack, player, world, pos, torchBlockState)) continue;
                double gauss = 0.5 + (double)(world.f_46441_.nextFloat() / 2.0f);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, gauss, gauss, 0.0);
                SoundType torchSoundType = torch.getSoundType(torchBlockState, (LevelReader)world, pos, null);
                world.m_5594_(null, pos, torchSoundType.m_56776_(), SoundSource.BLOCKS, (torchSoundType.m_56773_() + 1.0f) / 2.0f, torchSoundType.m_56774_() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private boolean findAndDrainSojournersStaff(Player player, Block torch) {
        if (player.m_7500_()) {
            return true;
        }
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            if (player.m_150109_().m_8020_(slot).m_41720_() != ModItems.SOJOURNER_STAFF.get() || !((SojournerStaffItem)ModItems.SOJOURNER_STAFF.get()).removeItemFromInternalStorage(player.m_150109_().m_8020_(slot), (ForgeRegistryEntry<?>)torch, 1, false, player)) continue;
            return true;
        }
        return false;
    }

    private Optional<Block> getTorchBlock(String registryName) {
        return Optional.ofNullable(TORCH_BLOCKS.computeIfAbsent(registryName, rn -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rn))));
    }

    @Nullable
    private BlockState getTorchSideAttempt(Player player, Block torch, BlockPos pos, Direction side) {
        return torch.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.m_82539_((Vec3i)pos), side, pos, false)));
    }

    private boolean placeBlockAt(ItemStack stack, Player player, Level world, BlockPos pos, BlockState torchBlockState) {
        if (!world.m_7731_(pos, torchBlockState, 3)) {
            return false;
        }
        torchBlockState.m_60734_().m_6402_(world, pos, torchBlockState, (LivingEntity)player, stack);
        return true;
    }
}

